<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class SessionStageRequest extends FormRequest {
    public function rules() {
        return [
            'id_classe' => 'required',
            'id_type_stage' => 'required',
            'nom' => 'required',
            'date_deb' => 'required|date_format:d/m/Y',
            'date_fin' => 'required|date_format:d/m/Y|after:date_deb',
        ];
    }
 

     public function attributes() {
        return [
            'id_classe' => 'Classe',
            'id_type_stage' => 'Type de stage',
            'nom' => 'Nom',
            'date_deb' => 'Date de début',
            'date_fin' => 'Date de fin',

        ];
    }


    public function authorize() {
        return true;
    }
}