<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;


class Classe extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'classes';


	public function getNbElevesAttribute()
	{
	    $liste_users="";
		$nb =  DB::table('eleves')->where('id_classe', '=', $this->id)->count();

	    return $nb;
	 }

	public function getNomClasseAttribute()
	{

	    return $this->nom_court.' ('.$this->NbEleves.')';
	 }

	public function getNomEtablissementAttribute()
	{
		$etab=Etablissement::first(); // A CHANGER
		if(!$etab) return "";
	    return $etab->nom;
	 }


	public function getNomNiveauAttribute()
	{
		$niveau=Niveau::find($this->id_niveau);
		if(!$niveau) return "";
	    return $niveau->nom;
	 }

	public function getNomFiliereAttribute()
	{
		$filiere=Filiere::find($this->id_filiere);

		if(!$filiere) return "";

	    return $filiere->nom;
	 }



	public function getNomPPAttribute()
	{
		$enseignant=Enseignant::find($this->id_pp);
		if(!$enseignant) return "";
	    return $enseignant->nomcomplet;
	 }

	public function getSessionPeriodeAttribute()
	{
		$session=SessionStage::where('id_classe','=',$this->id)->first();
		if(!$session) return "";
	    return $session->Periode;
	 }

	public function getNomTypeStageAttribute()
	{
		$typestage=TypeStage::find($this->id_type_stage);
		if(!$typestage) return "";
	    return $typestage->nom;
	}

	public function getNomDiplomeAttribute()
	{
		$diplome=Diplome::find($this->id_diplome);
		if(!$diplome) return "";
	    return $diplome->nom;
	 }

	public function Calcul()
	{

	    return 1000+$this->NbEleves;
	 }

	 
}
