<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;


class Eleve extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'eleves';


    /* Dates */
    public function getDates()
    {
            return array('date_naissance');
    }


     public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }


    public function getNomCompletAttribute()
    {
        $prenom=$this->prenom;
        //if(strlen($this->prenom)>2) $prenom=substr($this->prenom,0,1).strtolower(substr($this->prenom,1));
        return $this->nom." ".$this->prenom;
    }

    /* Retour : nom_prenom_id (Destiné aux dossier élèvé créé) */
    public function getNomEleveSpecAttribute()
    {
        $nom_complet=$this->nom."_".$this->prenom;
        $nom_complet=str_replace(" ","",$nom_complet);
        $nom_complet=str_replace("'","",$nom_complet);
        $nom_complet=MyApp::enleveaccents($nom_complet);
        $nom_complet=strtoupper($nom_complet)."_".str_pad($this->id,4,"0",STR_PAD_LEFT);
        return $nom_complet;
    }


    /* *************************************** */
    /*                ETABLISSEMENT            */
    /* *************************************** */
    public function getEtablissement()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        $etablissement=Etablissement::find($classe->id_etablissement);
        return $etablissement;
    }

    public function getNomEtablissementAttribute()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        return $classe->nom_etablissement;
    }


    /* *************************************** */
    /*                CLASSE                   */
    /* *************************************** */

    /* Retour Nom+Classe+Etablissement */
    public function getClasse()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        return $classe;
    }

    /* Retour Nom+Classe+Etablissement */
    public function getNomClassEtabEleveHTMLAttribute()
    {
        $nom="<b>".$this->NomComplet."</b>";
        $nom.="<br/>".$this->NomClasseLong;
        $nom.="<br/>".$this->NomEtablissement;
        return $nom;
    }

    public function getNomClasseLongAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom;
    }

    public function getNomClasseAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom_court;
    }

     public function getNomProfAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom_pp;
    }


    public function getNomGroupesHTMLAttribute()
    {
        $sep="<br/>";
        $liste="";
        $groupeseleves=GroupeEleve::where('id_eleve','=',$this->id)->get();

        if(!$groupeseleves) return "";
        foreach($groupeseleves as $groupeeleve) {
            $liste.=(($liste=="")?"":$sep).$groupeeleve->NomGroupe;

        }
        return $liste;
    }



    /* *************************************** */
    /*                PROFESSEURS              */
    /* *************************************** */

/* C'est dans le stage
    public function getNomReferent1Attribute()
    {
        $enseignant=$this->getReferent1();
        if(!$enseignant) return "";
        return $enseignant->nom_complet;
    }

    public function getNomReferent2Attribute()
    {
        $enseignant=$this->getReferent2();
        if(!$enseignant) return "";
        return $enseignant->nom_complet;
    }

    public function getNomReferentsHTMLAttribute()
    {
        $referant1=$this->
        $nom_referent1=($this->NomReferent1!="")?$this->NomReferent1." (1)":"";
        $nom_referent2=($this->NomReferent2!="")?$this->NomReferent2." (2)":"";
        $nom_referent=$nom_referent1;
        $nom_referent.=($nom_referent1!="")?"<br>":"";
        $nom_referent.=$nom_referent2;
        return $nom_referent;
    }
*/

    /* *************************************** */
    /*                ENTREPRISE               */
    /* *************************************** */
     public function getNomEntrepriseAttribute()
    {
        $entreprise=Entreprise::find($this->id_classe);
        if(!$entreprise) return "";
        return $entreprise->nom;
    }

/*
     public function getStageEtatAttribute()
    {
        $stage=Stage::where('id_eleve','=',$this->id_eleve)->first();
        if(!$stage) return "-";
        return $stage->statut;
    }
*/


    /* *************************************** */
    /*                STAGE                    */
    /* *************************************** */
    public function getStage($id_session)
    {
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return "";
        return $stage;
    }

     public function getStageEtatAttribute($id_session)
    {
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return "";
        return $stage->statut;
    }


     public function getNomStageEtatAttribute($id_session)
    {
        $nom=$this->NomComplet;
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return $nom;
        return $nom." (".$stage->NomStatut.")";
    }


}
