<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;


class Filiere extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'filieres';


	public function getNbClassesAttribute()
	{
		$nb = DB::table('classes')
            ->where('classes.id_niveau', '=', $this->id)
            ->count();

	    return $nb;
	 }
	 
	public function getNbElevesAttribute()
	{
		$nb = DB::table('eleves')
            ->join('classes', 'eleves.id_classe', '=', 'classes.id')
            ->join('filieres', 'classes.id_filiere', '=', 'filieres.id')
            ->where('filieres.id','=',$this->id)
            ->count();

	    return $nb;
	 }

	public function getNbStagiairesAttribute()
	{
		$nb = DB::table('stages')
			->join('eleves', 'stages.id_eleve', '=', 'eleves.id')
            ->join('classes', 'eleves.id_classe', '=', 'classes.id')
            ->join('filieres', 'classes.id_filiere', '=', 'filieres.id')
            ->where('filieres.id','=',$this->id)
            ->count();

	    return $nb;
	 }

}
