@extends('layouts.dash')
@section('title') Rôles @stop
@section('title_card',"Rôles")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width=30%'>Nom</th>
                        <th >Utilisateurs</th>
                        <th width='75px'>
                            <a href="{!! url('roles/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($roles as $role)
                    <tr>
                        <td>
                            <a href="{!! url('roles/'.$role->id) !!}" >{!! $role->name !!}</a>
                        </td>
                        <td nowrap style=''>{!! $role->NomUsers !!}</td>
                         
                        <td nowrap>
                            <a href="./roles/{!! $role->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            {!! Form::open(['url' => url('roles/' . $role->id), 'method' => 'DELETE']) !!}
                            {{ csrf_field() }}
                            <button class="btn btn-danger">
                                <span class='ti-trash'></span>
                            </button>
                            {!! Form::close() !!}

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection


