@extends('layouts.dash')
@section('title') Utilisateurs @stop
@section('title_card',"Utilisateur")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th >Nom</th>
                        <th width='10%'>Identifiant</th>
                        <th width='10%'>Rôles</th>
                        <!-- <th width='10%'>Dernière connexion</th> -->
                        <th width='75px'>
                            <a href="{!! url('users/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($users_list as $user_row)
                    <tr>
                        <td>
                            <a href="{!! url('users/'.$user_row->id) !!}" >{!! $user_row->name !!}</a></td>
                        <td nowrap>{!! $user_row->email !!}</td>
                        <td nowrap>{!! $user_row->getRoles(); !!}</td>
                        <!-- <td nowrap>{!! $user_row->last_connection !!}</td> -->
                        <td nowrap>
                            <a href="{!! url('users/'.$user_row->id) !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            @if(
                            (!$user->hasRole("ADMINISTRATEUR"))
                            && (count($user_row->getRoleNames())==0)
                            && (!$user_row->hasAnyDirectPermission())
                            )

                                {!! Form::open(['url' => url('users/' . $user_row->id), 'method' => 'DELETE']) !!}
                                {{ csrf_field() }}
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                                {!! Form::close() !!}
                             @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection