@extends('layouts.dash_pop')

@section('title') Email Directeur @stop
@section('title_card',"Email de connexion pour ".$etablissement->directeur)
@section('subtitle_card',"Email de connexion")
@section('content')

    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    {!! Form::open(['email' => 'form', 
        'url' => "/acces_directeur_sendmail/", 'class' => 'form-horizontal']) !!}
        {!! Form::hidden('id_etablissement', $etablissement->id ) !!}
        {!! Form::hidden('lien', $lien ) !!}
        <div class="card">
            <div class="card-body">
                <div class="col-lg-12 col-lg-offset-1">
                    <div class='form-group '>
                        <div class='form-group'>
                            <div class="col-md-8 col-md-offset-1">
                                {!! Form::label('email', 'Email') !!}
                                {!! Form::text('email', $destinataire, ['placeholder' => 'Email du destinataire','class' => 'form-control']) !!}
                                @if($mode_test)
                                    <span class='badge badge-danger right'>Vous êtes en mode TEST, c'est pour cela que l'email de destination n'est pas celui du Directeur</span>
                                @endif
                            </div>
                        </div>
                        <div class='form-group'>
                            <div class="col-md-10 col-md-offset-1">
                                    {!! Form::label('objet', 'Objet') !!}
                                    {!! Form::text('objet', $objet, ['placeholder' => 'Objet','class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class='form-group'>
                            <div class="col-md-10 col-md-offset-1">
                                {!! Form::label('message', "Message (Le texte LIEN_FORM sera remplacé par le lien d'accès)") !!}
                                {!! Form::textarea('message', $message, ['placeholder' => 'Message', 'class' => 'form-control', 'rows'=>'10']) !!}
                            </div>
                        </div>
                        <div class="col-sm-9">
                            {!! Form::submit('Envoyer', ['class' => 'btn btn-primary']) !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    {!! Form::close() !!}
@endsection
@section('scripts')

@endsection
