@extends('layouts.dash')

@section('title') Filières @stop
@section('title_card',"Filières")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <label>Catégorie</label>
                    {!! Form::select('id_categorie',$categories,($categorie)?$categorie->id:'',
                        ['id'=>'select_id_categorie','placeholder' => 'Choisir une catégorie','class' => 'form-control','onchange'=>'select_filtre()']) 
                    !!} 
                </div>
            </div>

            <script>
                function select_filtre() {
                    var select_id_categorie = document.getElementById('select_id_categorie');
                    var select_id_categorie = [...select_id_categorie.selectedOptions].map(option => option.value);
                    var url="" ; 
                    if(select_id_categorie=="") select_id_categorie=0;
                    url="{!! url('filieres_list/') !!}/"+select_id_categorie;
                    location.href=url;
                }
            </script>
        </div>
        <div class="card-body">
        @if($categorie)
        <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th width='10%'>Nombre de&nbsp;classes</th>
                    <th width='10%'>Nombre d'élèves</th>
                    <th width='10%'>Nombre de&nbsp;stagiaires</th>
                    <th width='128px'>
                        <a href="{!! url('filieres/create') !!}" 
                            class="btn btn-success btn-sm">
                            Ajouter une filière
                        </a>  
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($filieres as $filiere)
                <tr class=''>
                    <td nowrap>
                        <a href="{!! url('/filieres/'.$filiere->id) !!}">{!! $filiere->nom !!}</a>
                    </td>
                    <td align="center">{!! $filiere->nb_classes !!}</td>
                    <td align="center">{!! $filiere->NbEleves !!}</td>
                    <td align="center">{!! $filiere->nb_stagiaires !!}</td>
                    <td align="center">
                        @if(($filiere->nb_classes==0) && ($filiere->NbEleves==0) && ($filiere->nb_stagiaires==0) )
                            {!! Form::open(['url' => url('filieres/' . $filiere->id), 'method' => 'DELETE']) !!}
                            {{ csrf_field() }}
                            <button class="btn btn-danger btn-sm">
                                <span class='fa fa-trash'></span>
                            </button>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endif
    </div>
</div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection
