@extends('layouts.dash')

@section('title') Cat.Filières @stop
@section('title_card',"Catégories de Filières")
@section('subtitle_card',"Liste complète")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-body">
           <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th width='1px'>Nom court</th>
                        <th width='10%'>Filières</th>
                        <th width='1px'>Nombre de&nbsp;classes</th>
                        <th width='1px'>Nombre d'élèves</th>
                        <th width='1px'>Nombre de&nbsp;stagiaires</th>
                        <th width='128px'>
                            <a href="{!! url('filieres_categories/create') !!}" 
                                class="btn btn-success btn-sm">
                                <span class='fa fa-plus'></span> Ajouter une catégorie
                            </a>  
                        </th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($filieres_categories as $categorie)
                    <tr class=''>
                        <td nowrap>
                            <a href="{!! url('/filieres_categories/'.$categorie->id) !!}">{!! $categorie->nom !!}</a>
                        </td>
                        <td nowrap>{!! $categorie->nom_court !!}</td>
                        <td>{!! $categorie->FilieresHTML !!}</td>
                        <td align="center">{!! $categorie->nb_classes !!}</td>
                        <td align="center">{!! $categorie->NbEleves !!}</td>
                        <td align="center">{!! $categorie->nb_stagiaires !!}</td>
                        <td align="center">
                            @if(1==1)
                                {!! Form::open(['url' => url('filieres_categories/' . $categorie->id), 'method' => 'DELETE']) !!}
                                {{ csrf_field() }}
                                <button class="btn btn-danger btn-sm">
                                    <span class='fa fa-trash'></span>
                                </button>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
     
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection
