<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>JPN-2023</title>
        <link rel="shortcut icon" href="<?php echo url('/img/logo.ico'); ?>">
        
        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">

        <!-- Styles -->
        <style>
            html, body {
                background-color: #fff;
                color: #636b6f;
                font-family: 'Nunito', sans-serif;
                font-weight: 200;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 84px;
            }

            .subtitle {
                font-size: 34px;
            }

            .subtitle2 {
                font-size: 22px;
            }

            .links > a {
                color: #636b6f;
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 10px;
            }
        </style>
    </head>
    <body>
        <div class="flex-center position-ref full-height">
            <?php if(Route::has('login')): ?>
                <div class="top-right links">
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(url('/home')); ?>">Accueil</a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>">Se connecter</a>

                        <?php if(Route::has('register')&&(0==1)): ?>
                            <a href="<?php echo e(route('register')); ?>">S'enregistrer</a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="content" style="margin-top:-230px">
                <div class="form-group row" >
                    <div class="col-md-6 ">
                        <img src="<?php echo url('/img/logo.png'); ?>" width="60%" alt="Logo" >
                    </div>
                    <div class="col-md-6 ">
                        <div   class="subtitle m-b-md">
                            Etablissements scolaires - 2023<br/>
                            <small>Académie de la Nouvelle Calédonie </small>
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <div class="main-footer">
                        <!-- iNEO Nouvelle-Calédonie -->
                    </div>
                </div>
            </div>


        </div>

    </body>
</html>
<?php /**PATH /var/www/html/gpfmp_etablissement/resources/views/welcome.blade.php ENDPATH**/ ?>