<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Classe;
use App\Models\Etablissement;
use App\Models\Enseignant;
use App\Models\Filiere;
use App\Models\Niveau;
use App\Models\Diplome;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\ClasseRequest;


class ClassesController extends Controller {
    private $menu='structures';
    private $submenu='classes';


    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter classes")) return Redirect::route('home');

        $classes=Classe::all();
        return View::make('structures.classes.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'classes' =>$classes
        ]);

    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter classes")) return Redirect::route('home');

        $mode="create";
        //Listes
        $enseignants=$this->getEnseignants();
        $filieres=$this->getFilieres();
        $niveaux=$this->getNiveaux();
        $diplomes=$this->getDiplomes();
        return View::make('structures.classes.create',[
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
                'niveaux' => $niveaux,
                'filieres' => $filieres,
                'diplomes' => $diplomes,
                'enseignants' => $enseignants,
            ]);
    }

    public function store(ClasseRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter classes")) return Redirect::route('home');

        $classe = $this->setData($request);
        $msg="La classe ".$classe->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/classes');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier classes")) return Redirect::route('home');

        $classe = Classe::find($id);
        //Listes
        $enseignants=$this->getEnseignants();
        $filieres=$this->getFilieres();
        $niveaux=$this->getNiveaux();
        $diplomes=$this->getDiplomes();
        return View::make('structures.classes.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'classe' => $classe,'user' => $user,
            'niveaux' => $niveaux,
            'filieres' => $filieres,
            'diplomes' => $diplomes,
            'enseignants' => $enseignants,
            ]);
    }
 
    public function update($id,ClasseRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier classes")) return Redirect::route('home');

        $classe = $this->setData($request,$id);
        $msg="La classe ".$classe->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/classes');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter classes")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer classes")) return Redirect::route('home');

        $classe = Classe::find($id);
        $nom=$classe->nom;
        if(!$classe->CanDelete) {
            $msg="La classe ".$nom." ne peut pas être supprimée";
        } else {
            Classe::destroy($id);
            $msg="La classe ".$nom." a été supprimée";   
        }  
        Session::flash('success', $msg);   
        return Redirect::to('/classes');
    }


    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $classe =  new Classe;
        else $classe = Classe::find($id);

        $classe->nom=($request->nom);
        $classe->nom_court=strtoupper($request->nom_court);
        $classe->groupe=($request->groupe=='')?0:1;
        $classe->id_niveau=$request->id_niveau;
        $classe->id_filiere=$request->id_filiere;
        $classe->id_pp=$request->id_pp;
        $classe->id_diplome=$request->id_diplome;
        $classe->save();
 
        return $classe;
    }

    public function getEnseignants() {
        $enseignants=array();
        $t_enseignants = Enseignant::orderby('nom')->get();
        foreach($t_enseignants as $enseignant) $enseignants[$enseignant->id]=$enseignant->NomComplet;  
        return $enseignants;  
    }

    public function getFilieres() {
       $filieres=array();
            $t_filieres = Filiere::select('nom','id')->orderby('nom')->get();
            foreach($t_filieres as $filiere) $filieres[$filiere->id]=$filiere->nom;   
        return $filieres;  
    }
    public function getNiveaux() {
        $niveaux=array();
        $t_niveaux = Niveau::select('nom','id')->orderby('nom')->get();
        foreach($t_niveaux as $niveau) $niveaux[$niveau->id]=$niveau->nom;  
        return $niveaux;  
    }
    public function getDiplomes() {
        $diplomes=array();
        $t_diplomes = Diplome::select('nom','id')->orderby('nom')->get();
        foreach($t_diplomes as $diplome) $diplomes[$diplome->id]=$diplome->nom; 
        return $diplomes;
    }
}