<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Diplome;
use App\Models\Filiere;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\DiplomeRequest;


class DiplomesController extends Controller {

    private $menu='parametres';
    private $submenu='diplomes';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter diplomes")) return Redirect::route('home');

        $diplomes = Diplome::all();
        return View::make('structures.diplomes.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'diplomes' => $diplomes,
        ]);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter diplomes")) return Redirect::route('home');

        $mode="create";
        $filieres=array();
        $t_filiere = Filiere::select('nom','id')->orderby('nom')->get();
        foreach($t_filiere as $filiere) $filieres[$filiere->id]=$filiere->nom;

        return View::make('structures.diplomes.create',[
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'filieres' => $filieres,
        ]);
    }

    public function store(DiplomeRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter diplomes")) return Redirect::route('home');

        $diplome = $this->setData($request);
        $msg="Le diplôme ".$diplome->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/diplomes');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier diplomes")) return Redirect::route('home');

        $diplome = Diplome::find($id);

        $filieres=array();
        $t_filiere = Filiere::select('nom','id')->orderby('nom')->get();
        foreach($t_filiere as $filiere) $filieres[$filiere->id]=$filiere->nom;


        return View::make('structures.diplomes.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'diplome' => $diplome,
            'filieres' => $filieres,
            ]);
    }
 
    public function update($id,DiplomeRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier diplomes")) return Redirect::route('home');

        $diplome = $this->setData($request,$id);
        $msg="La diplôme ".$diplome->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/diplomes');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter diplomes")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer diplomes")) return Redirect::route('home');

        $diplome = Diplome::find($id);
        $nom=$diplome->nom;
        if(!$diplome->CanDelete) {
            $msg="Le diplôme ".$nom." ne peut pas être supprimé";
        } else {
            Filiere::destroy($id);
            $msg="Le diplôme ".$nom." a été supprimé";   
        }  
        Session::flash('success', $msg);      
        return Redirect::to('/diplomes');
    }


    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $diplome =  new Diplome;
        else $diplome = Diplome::find($id);

        $diplome->nom=($request->nom);
        $diplome->nom_court=strtoupper($request->nom_court);
        $diplome->id_filiere=$request->id_filiere;
        $diplome->save();

        return $diplome;
    }

}