<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Enseignant;
use App\Models\Classe;
use App\Models\EnseignantClasse;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\EnseignantRequest;

class EnseignantsController extends Controller {

    private $menu='structures';
    private $submenu='enseignants';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter enseignants")) return Redirect::route('home');

        $enseignants = Enseignant::all();
        return View::make('structures.enseignants.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'enseignants' =>$enseignants
        ]);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter enseignants")) return Redirect::route('home');

        $mode="create";
        $classes = Classe::orderby('nom','ASC')->pluck('nom','id')->toArray();

        return View::make('structures.enseignants.create',[
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
                "classes" => $classes, 
            ]);
    }

    public function store(EnseignantRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter enseignants")) return Redirect::route('home');

        $enseignant=$this->setData($request);

        return Redirect::to('/enseignants');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier enseignants")) return Redirect::route('home');

        $enseignant = Enseignant::find($id);
        $classes = Classe::orderby('nom','ASC')->pluck('nom','id')->toArray();
        $enseignantsclasses=DB::table('enseignants_classes')
            ->where('id_enseignant', '=', $id)->pluck("id_classe")->toArray();

        return View::make('structures.enseignants.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'enseignant' => $enseignant,
            "classes" => $classes,
            "enseignantsclasses" => $enseignantsclasses,
            ]);
    }
 
    public function update($id,EnseignantRequest $request)
    { 
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier enseignants")) return Redirect::route('home');

        $enseignant = $this->setData($request,$id);
        $msg="La fiche de l'enseignant ".$enseignant->NomComplet." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/enseignants');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter enseignants")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer enseignants")) return Redirect::route('home');

        $enseignant=Enseignant::find($id);
        $nom=$enseignant->NomComplet;
        if(!$enseignant->CanDelete) {
            $msg="La fiche enseignant ".$nom." ne peut pas être supprimée";
        } else {
            Enseignant::destroy($id);
            $msg="La fiche enseignant ".$nom." a été supprimée";   
        }  
        Session::flash('success', $msg);   
        return Redirect::to('/enseignants');
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $enseignant = new Enseignant;
        else $enseignant = Enseignant::find($id);

        $enseignant->nom=strtoupper($request->nom);
        $enseignant->prenom=($request->prenom);
        $enseignant->civilite=$request->civilite;
        $enseignant->tel_mobile=$request->tel_mobile;
        $enseignant->tel_fixe=$request->tel_fixe;
        $enseignant->discipline=$request->discipline;
        $enseignant->email=$request->email;
        $enseignant->save();
 
         //Attach classes
        $t_classes = $request->enseignantclasses;
        if($id!="") { //Détache les ancienes classes
            EnseignantClasse::where('id_enseignant','=',$enseignant->id)->delete();
        }
        if($t_classes) {
            foreach($t_classes as $classe) {
                $classe=intVal($classe);
                if($classe>0) {
                    $enseignantclasse=new EnseignantClasse;
                    $enseignantclasse->id_enseignant=$enseignant->id;
                    $enseignantclasse->id_classe=$classe;
                    $enseignantclasse->save();
                }
            }
        }
        return $enseignant;
    }

}