<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\FiliereCategorie;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\FiliereCategorieRequest;


class FilieresCategoriesController extends Controller {

    private $menu='parametres';
    private $submenu='filieres_categories';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter filieres categories")) return Redirect::route('home');

        $filieres_categories = FiliereCategorie::all();
        return View::make('structures.filieres_categories.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'filieres_categories' =>$filieres_categories,            
        ]);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter filieres categories")) return Redirect::route('home');

        $mode="create";
        return View::make('structures.filieres_categories.create',[
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            ]);

    }

    public function store(FiliereCategorieRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter filieres categories")) return Redirect::route('home');

        $filiere_categorie = $this->setData($request);
        $msg="La catégorie de filière ".$filiere_categorie->nom." a été créée";
        Session::flash('success', $msg); 
       return Redirect::to('/filieres_categories');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier filieres categories")) return Redirect::route('home');

        $filiere_categorie = FiliereCategorie::find($id);
        return View::make('structures.filieres_categories.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'filiere_categorie' => $filiere_categorie,
            ]);
    }
 
    public function update($id,FiliereCategorieRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier filieres categories")) return Redirect::route('home');

        $filiere_categorie = $this->setData($request,$id);
        $msg="La catégorie de filière ".$filiere_categorie->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/filieres_categories');
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter filieres categories")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer filieres categories")) return Redirect::route('home');

        $filiere_categorie = FiliereCategorie::find($id);
        $nom=$filiere_categorie->nom;
        if(!$filiere_categorie->CanDelete){
            $msg="La catégorie de filière  ".$nom." ne peut pas être supprimée";
        } else {
            FiliereCategorie::destroy($id);
            $msg="La catégorie de filière  ".$nom." a été supprimée";
        }
        Session::flash('success', $msg);
        return Redirect::to('/filieres_categories');
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $filiere_categorie =  new FiliereCategorie;
        else $filiere_categorie = FiliereCategorie::find($id);

        $filiere_categorie->nom=$request->nom;
        $filiere_categorie->nom_court=$request->nom_court;
        $filiere_categorie->save();
 
        return $filiere_categorie;
    }
}