<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class UserRequest extends FormRequest {
    public function rules() {

        switch ($this->method()) {
            case 'PUT':
                //$emailRules = "required";
                $emailRules = "required|unique:users,email,{$this->id},id,deleted_at,NULL";
                break;
            default:
                //$emailRules = "required|unique:users,email,NULL,id,deleted_at,NULL";
                $emailRules = "required|unique";
                break;
        }

        return [
            'name' => 'required|max:100',
            //'email' => 'required|email|unique:users,email,'. $this->id,
            'password' => '',
        ];
    }
 

/*
    protected $rules_update = [
        'email' => 'required|email|unique:users,email,'. $this->id,
        'name' => 'required|max:100',
        'password' => "required|min:6|same:password_confirm",
        'password_confirm' => "required:min:6|same:password",
        'password_current' => "required:min:6"
    ];
    */


     public function attributes() {
        return [
            'name' => 'Nom',
            'email' => 'Email',
            'password' => 'Mot de passe',
        ];
    }


    public function authorize() {
        return true;
    }
}