<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;


class Classe extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'classes';


	/* **************** */
	/* ETABLISSEMENT    */
	/* **************** */
	public function getNomEtablissementAttribute()
	{
		$etab=Etablissement::first(); // A CHANGER
		if(!$etab) return "";
	    return $etab->nom;
	}


	/* ********** */
	/* CLASSE     */
	/* ********** */
	public function getNomClasseAttribute()
	{
	    return $this->nom_court.' ('.$this->NbEleves.')';
	}


	/* ********** */
	/* ELEVES     */
	/* ********** */
	public function getNbElevesAttribute()
	{
	    $liste_users="";
		$nb =  DB::table('eleves')->where('id_classe', '=', $this->id)->count();

	    return $nb;
	}


	/* ********** */
	/* FILIERES   */
	/* ********** */
	public function getNomFiliereAttribute()
	{
		$filiere=Filiere::find($this->id_filiere);

		if(!$filiere) return "";

	    return $filiere->nom;
	}


	/* ********** */
	/* DIPLOMES   */
	/* ********** */
	public function getNomDiplomeAttribute()
	{
		$diplome=Diplome::find($this->id_diplome);
		if(!$diplome) return "";
	    return $diplome->nom;
	}



	/* ********** */
	/* NIVEAU     */
	/* ********** */
	public function getNomNiveauAttribute()
	{
		$niveau=Niveau::find($this->id_niveau);
		if(!$niveau) return "";
	    return $niveau->nom;
	}



	/* *************** */
	/* PROFESSEURS     */
	/* *************** */
	public function getNomPPAttribute()
	{
		$enseignant=Enseignant::find($this->id_pp);
		if(!$enseignant) return "";
	    return $enseignant->nomcomplet;
	}



	/* *************** */
	/* STAGES          */
	/* *************** */



	public function getSessionWeek($semaine,$groupe)
	{
		$week=MyApp::week2day($semaine);

		$date_deb=$week[0];
		$date_fin=$week[1];
		
		/*
		$session=SessionStage::where('id_classe','=',$this->id)
            ->where(function ($query) use ($date_deb,$date_fin) {
                $query->whereBetween('date_deb',[$date_deb,$date_fin])
                    ->orwhereBetween('date_fin',[$date_deb,$date_fin]);
                })
			->first();
		*/

		$session=SessionStage::where('id_classe','=',$this->id)
			->where(function ($query) use ($date_deb,$date_fin) {
                $query->where('date_deb',"<=",$date_deb)
                    ->orwhere('date_deb',"<",$date_fin);
                })
			->where(function ($query) use ($date_deb,$date_fin) {
                $query->where('date_fin',">=",$date_fin)
                    ->orwhere('date_fin',">",$date_deb);
                })
			->first();


		//if($semaine==31) dd($session);
		if(!$session) return "";
	    return $session;
	 }

	public function getSessionPeriodeAttribute()
	{
		$session=SessionStage::where('id_classe','=',$this->id)->first();
		if(!$session) return "";
	    return $session->Periode;
	 }

	public function getNomTypeStageAttribute()
	{
		$typestage=TypeStage::find($this->id_type_stage);
		if(!$typestage) return "";
	    return $typestage->nom;
	}


	/* ********** */
	/* CAN DELETE */
	/* ********** */
    public function getCanDeleteAttribute()
    {
    	if(!($user=Auth::user())) return Redirect::route( 'login' );
    	if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer classes")) return false;
        $nb=$this->NbEleves;
        if($nb==0) return true;
        return false;
    }







	 
}
