<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;


class Eleve extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'eleves';


    /* Dates */
    public function getDates()
    {
            return array('date_naissance');
    }


     public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }


    public function getNomCompletAttribute()
    {
        $prenom=$this->prenom;
        //if(strlen($this->prenom)>2) $prenom=substr($this->prenom,0,1).strtolower(substr($this->prenom,1));
        return $this->nom." ".$this->prenom;
    }

    /* Retour : nom_prenom_id (Destiné aux dossier élèvé créé) */
    public function getNomEleveSpecAttribute()
    {
        $nom_complet=$this->nom."_".$this->prenom;
        $nom_complet=str_replace(" ","",$nom_complet);
        $nom_complet=str_replace("'","",$nom_complet);
        $nom_complet=MyApp::enleveaccents($nom_complet);
        $nom_complet=strtoupper($nom_complet)."_".str_pad($this->id,4,"0",STR_PAD_LEFT);
        return $nom_complet;
    }

    /* ********** */
    /* CAN DELETE */
    /* ********** */
    public function getCanDeleteAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer eleves")) return false;

        if($this->NbStages!=0) return false;
        return true;
    }


    /* *************************************** */
    /*                ETABLISSEMENT            */
    /* *************************************** */
    public function getEtablissement()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        $etablissement=Etablissement::find($classe->id_etablissement);
        return $etablissement;
    }

    public function getNomEtablissementAttribute()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        return $classe->nom_etablissement;
    }


    /* *************************************** */
    /*                CLASSE                   */
    /* *************************************** */

    /* Retour Nom+Classe+Etablissement */
    public function getClasse()
    {
        $classe=Classe::find($this->id_classe);
        if(!$classe) return "";
        return $classe;
    }

    /* Retour Nom+Classe+Etablissement */
    public function getNomClassEtabEleveHTMLAttribute()
    {
        $nom="<b>".$this->NomComplet."</b>";
        $nom.="<br/>".$this->NomClasseLong;
        $nom.="<br/>".$this->NomEtablissement;
        return $nom;
    }

    public function getNomClasseLongAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom;
    }

    public function getNomClasseAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom_court;
    }

     public function getNomProfAttribute()
    {
        $classe=$this->getClasse();
        if(!$classe) return "";
        return $classe->nom_pp;
    }


    public function getNomGroupesHTMLAttribute()
    {
        $sep="<br/>";
        $liste="";
        $groupeseleves=GroupeEleve::where('id_eleve','=',$this->id)->get();

        if(!$groupeseleves) return "";
        foreach($groupeseleves as $groupeeleve) {
            $liste.=(($liste=="")?"":$sep).$groupeeleve->NomGroupe;

        }
        return $liste;
    }


    /* *************************************** */
    /*                ENTREPRISE               */
    /* *************************************** */



    /* *************************************** */
    /*                STAGE                    */
    /* *************************************** */
    public function getNbStagesAttribute()
    {
        $nb=Stage::where('id_eleve','=',$this->id)->count();
        return $nb;
    }

    public function getStage($id_session)
    {
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return "";
        return $stage;
    }

     public function getStageEtatAttribute($id_session)
    {
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return "";
        return $stage->statut;
    }


     public function getNomStageEtatAttribute($id_session)
    {
        $nom=$this->NomComplet;
        $stage=Stage::where('id_eleve','=',$this->id)->where('id_session','=',$id_session)->first();
        if(!$stage) return $nom;
        return $nom." (".$stage->NomStatut.")";
    }


}
