<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;
use App\User;

class Enseignant extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'enseignants';

    /* ***************** */
    /*   NOM - identité
    /* ***************** */
    public function getNomCompletAttribute()
    {
        $prenom=$this->prenom;
        if(strlen($this->prenom)>2) $prenom=substr($this->prenom,0,1).strtolower(substr($this->prenom,1));
        return $this->nom." ".$prenom." (".strtoUpper($this->civilite).")";
    }

    public function gettelHTMLAttribute()
    {
        $tel="";
        if($this->tel_mobile!="") $tel=trim($this->tel_mobile);
        if($this->tel_fixe!="") $tel.=($tel=="")?$this->tel_fixe:"<br/>".$this->tel_fixe;
        
        return $tel;
    }

    /* ********** */
    /* CAN DELETE */
    /* ********** */
    public function getCanDeleteAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer enseignants")) return false;
        if($this->NbClasse!=0) return false;
        $nb_ref1=Stage::where('id_enseignant','=',$this->id)->count();
        if($nb_ref1!=0) return false;
        $nb_ref2=Stage::where('id_enseignant2','=',$this->id)->count();
        if($nb_ref2!=0) return false;
        return true;
    }


    /* ***************** */
    /*   Compte USER
    /* ***************** */
    public function getHasAccountAttribute()
    {
        $user=User::where('email','=',$this->email)->first();
        if(!$user) return false;
        return true;
    }


    /* ***************** */
    /*   CLASSE & REFERENT
    /* ***************** */
    public function getNbClasseAttribute()
    {
        $lst="";
        $nb=EnseignantClasse::where('id_enseignant','=',$this->id)->count();

        return $nb;
    }

    public function getListeClasseAttribute()
    {
    	$lst="";
    	$enseignantclasses=EnseignantClasse::where('id_enseignant','=',$this->id)->get();
    	foreach($enseignantclasses as $enseignantclasse) {
            $classe=Classe::find($enseignantclasse->id_classe);
            $pp=($classe->id_pp==$this->id)?" <b>(PP)</b>":"";
            $lst.=(($lst=="")?"":"<br>").$enseignantclasse->NomClasse.$pp;
        }
        return $lst;
    }

    public function getReferentNbInfoAttribute()
    {
        $msg="";
        $nb_ref1=Stage::where('id_enseignant','=',$this->id)->count();
        $nb_ref2=Stage::where('id_enseignant2','=',$this->id)->count();

        if(($nb_ref1==0)&&($nb_ref2==0)) return "";

        $msg="<span style='margin:0px;padding:0px;color:green'>Réf1 : ".$nb_ref1."</span>";
        $msg.="<br>";
        $msg.="<span style='margin:0px;padding:0px;color:blue'>Réf2 : ".$nb_ref2."</span>";
        return "".$msg."</span>";
    }

    public function getReferentListeElevesAttribute()
    {
        $liste_ref1="";
        $liste_ref2="";
        $stages_ref1=Stage::where('id_enseignant','=',$this->id)->get();
        $stages_ref2=Stage::where('id_enseignant2','=',$this->id)->get();
        foreach($stages_ref1 as $stage_ref1) 
            $liste_ref1.=(($liste_ref1=="")?"":"<br>").$stage_ref1->getEleve()->NomComplet." - ".$stage_ref1->getEleve()->NomClasse;

        foreach($stages_ref2 as $stage_ref2) 
            $liste_ref2.=(($liste_ref1=="")?"":"<br>").$stage_ref2->getEleve()->NomComplet." - ".$stage_ref2->getEleve()->NomClasse;


        $res="<b>En qualité de référent 1 :</b><br>";
        $res.=($liste_ref1=="")?"Aucun":$liste_ref1;

        $res.="<br><br><b>En qualité de référent 2 :</b><br>";
        $res.=($liste_ref2=="")?"Aucun":$liste_ref2;

        return $res;
    }

}
