<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;
use DB;

class Offre extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'offres';


    public function getDateDebAttribute($value)
    {
        return ($this->attributes['date_deb']!=null)?date('d/m/Y', strtotime($this->attributes['date_deb'])):null;
    }

    public function getDateFinAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['date_fin'])):null;
    }


    public function getPeriodeAttribute()
    {
        $periode=$this->DateDeb."&nbsp;au&nbsp;".$this->DateFin;
        return $periode;
    }


    public function getNomCategorieAttribute()
    {
        $categorie=Categorie::find($this->id_categorie);
        if(!$categorie) return "";
        return $categorie->nom;
    }

    public function getNomNiveauAttribute()
    {
        $niveau=Niveau::find($this->id_niveau);
        if(!$niveau) return "";
        return $niveau->nom;
    }

    public function getNomFiliereAttribute()
    {
        $filiere=Filiere::find($this->id_filiere);
        if(!$filiere) return "";
        return $filiere->nom;
    }

    public function getNomStatutAttribute()
    {
        $statuts=MyApp::STATUTS_OFFRES;

        return $statuts[$this->statut];
    }

    public function getColorStatutAttribute()
    {
        $colors=MyApp::STATUTS_COLORS;

        return $colors[$this->statut];
    }

    public function getCibleAttribute()
    {
        $filiere=$this->NomFiliere;
        $niveau=$this->NomNiveau;
   
        return $niveau."/".$filiere;
    }

    public function getContactCompletAttribute()
    {
        $contact=$this->NomFiliere;
        $email=$this->email;
        $tel=$this->tel;
   
        return $contact.($email?"<br>".$email:"").($tel?"<br>".$tel:"");
    }
    
}