<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;


class SessionStage extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'sessions';

    /* Dates */
    public function getDates()
    {
            return array('date_deb','date_fin');
    }


     public function getDateDebAttribute($value)
    {
        return ($this->attributes['date_deb']!=null)?date('d/m/Y', strtotime($this->attributes['date_deb'])):null;
    }

     public function getDateFinAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['date_fin'])):null;
    }

    public function getDateDebUSAttribute($value)
    {
        return ($this->attributes['date_deb']!=null)?date('Y-m-d', strtotime($this->attributes['date_deb'])):null;
    }


    public function getDateFinUSAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['date_fin'])):null;
    }

     public function getStatutAttribute()
    {
        $date=date("Y-m-d");
        $res="TER";
        if(($date>$this->attributes['date_deb'])&&($date<=$this->attributes['date_fin'])) 
            return  "ENC";
       if($date<$this->attributes['date_deb'])  return "PRE";
        return $res;
    }


     public function getNomCompletAttribute()
    {
        $periode="du ".$this->DateDeb." au ".$this->DateFin;
        $res=$this->nom.$periode;
        return $res;
    }

    public function getDetailAttribute()
    {
        $classe=$this->getClasse();
        $periode="du ".$this->DateDeb." au ".$this->DateFin;
        $res="Diplôme: ".$classe->NomDiplome.
            '&#10;Classe: '.$classe->NomClasse.
            '&#10;Session: '.$this->nom.
            "&#10;Période: ".$periode;
        return $res;
    }

     public function getNomTypeStageAttribute()
    {
        $typestage=TypeStage::find($this->id_type_stage);
        if(!$typestage) return "";
        return $typestage->nom;
    }

    /* ********************* */
    /*    DIVERS */
    /* ********************* */
    public function getCanDeleteAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole("ADMINISTRATEUR") && !$user->can("supprimer sessions")) return false;
        $nb=$this->NbStages;
        if($nb==0) return true;
        return false;
    } 


    /* ********************* */
    /*    DUREEE */
    /* ********************* */
     public function getDureeAttribute()
    {
        $origin=date_create($this->attributes['date_deb']);
        $target=date_create($this->attributes['date_fin']);

        $interval = date_diff($origin, $target);
        $interval->format('%R%a days');
        return $interval->d;
    }


     public function getPeriodeAttribute()
    {
        $periode=$this->DateDeb." au ".$this->DateFin;
        return $periode;
    }


     public function getNomEtablissementAttribute()
    {

        $classe=Classe::find($this->id_classe);
        return $classe->NomEtablissement;
    }

     public function getClasse()
    {
        $classe=Classe::find($this->id_classe);
        return $classe;
    }

     public function getNomClasseAttribute()
    {
        return $this->getClasse()->nom;
    }

     public function getNbElevesAttribute()
    {
        $classe=Classe::find($this->id_classe);
        return $classe->nb_eleves;
    }

    

    /* ********************* */
    /*    STAGES et SESSIONS */
    /* ********************* */
    public function getNbStagesAttribute()
    {
        $nb=Stage::where("id_session","=",$this->id)->count();
        return $nb;
    }

    public function getNbStagesSansEntrepriseAttribute()
    {
        $nb=Stage::where("id_session","=",$this->id)->whereNull("id_entreprise","=",$this->id)->count();
        return $nb;
    }




    /* ********************* */
    /*    DOCUMENTS          */
    /* ********************* */

    public function getNbAttestationsAttribute()
    {

        return 0;
    }

    public function getNbConventionsAttribute()
    {

        return 0;
    }

    public function getDocumentsAttribute()
    {
        $nb_attestations=$this->NbAttestations;
        $nb_conventions=$this->NbConventions;
        $msg=" Attestations : ".$nb_attestations;
        $msg.="<br/>";
        $msg.=" Conventions : ".$nb_conventions;
        return $msg;
    }


}
