@extends('layouts.sessions')

@section('content')

<div class="card">
    <div class="card-header">
        <strong class="card-title">Mise à jour d'une session</strong>
    </div>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <div class="col-lg-max col-lg-offset-1 container-fluid">
 
        {!! Form::model($sessionstage, ['class' => 'form-horizontal', 'url' => '/sessions/' . $sessionstage->id, 'method' => 'PUT']) !!}
  
         <div class="form-group row">
            <div class="col-md-5">
                {!! Form::label('nom', 'Nom') !!}
                {!! Form::text('nom', null, [
                'class' => 'form-control','readonly']) !!}
            </div>
        </div>


            <div class="form-group row">
                <div class='col-md-4'>
                    {!! Form::label('date_deb', 'Date de debut', ['class' => '']) !!}
                    <div class="input-group">
                        <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                        {!! Form::text('date_deb', $sessionstage->date_deb, ['placeholder' => 'Date de début', 
                        'class' => 'form-control',
                        'readonly'
                        ]) !!}
                    </div>
                </div>

                <div class='col-md-4'>
                    {!! Form::label('date_fin', 'Date de fin', ['class' => '']) !!}
                    <div class="input-group">
                        <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                        {!! Form::text('date_fin', $sessionstage->date_fin, ['placeholder' => 'Date de fin', 'class' => 'form-control',
                        'readonly'
                        ]) !!}
                    </div>
                </div>
            </div>


            <div class="form-group row">
                <div class='col-md-4'>
                    {!! Form::label('id_type_stage', 'Type de stage') !!}
                    <div class="input-group">
                        <div class="input-group-addon"><i class="fa fa-globe"></i></div>
                        {!! 
                            Form::select(
                                'id_type_stage',
                                array(""=>" ")+$types,
                                $sessionstage->type,
                                [
                                    'class' => 'form-control',
                                    'readonly'
                                ]
                            ) 
                        !!} 
                    </div>
                </div>
            </div>


            <div class="form-group row">
                <div class='col-md-4'>
                    {!! Form::label('id_classe', 'Classe') !!}
                    <div class="input-group">
                        <div class="input-group-addon"><i class="fa fa-book"></i></div>
                        {!! 
                            Form::select(
                                'id_classe',
                                array(""=>" ")+$classes,
                                $sessionstage->id_classe,
                                [
                                    'class' => 'form-control',
                                    'readonly'
                                ]
                            ) 
                        !!} 

                    </div>
                </div>
            </div>

        <div class='form-group'>
            <a class="btn btn-warning" href="{!! url('/sessions_spec/terminees') !!}">
                Retour</a> 
        </div>

        {{ html()->form()->close() }}
 
    </div>
 
</div>

@endsection
