@extends('layouts.stages')

{!! $with_navbar=false !!}
@section('title')Eleves @stop
@section('title_card',"Nouvelle session de stage")

@section('content')
<div class="card"> 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="col-lg-max col-lg-offset-1 container-fluid">
        {!! Form::open(['class' => 'form-horizontal', 'url' => '/sessions']) !!}
         <div class="form-group row">
            <div class="col-md-5">
                {!! Form::label('nom', 'Nom') !!}
                {!! Form::text('nom', null, ['placeholder' => 'Déniomnation de la session', 'class' => 'form-control']) !!}
            </div>
        </div>
        <div class="form-group row">
            <div class='col-md-3'>
                {!! Form::label('date_deb', 'Date de debut', ['class' => '']) !!}
                {!! Form::text('date_deb','', 
                        ['placeholder' => 'Date', 'class' => 'form-control']) !!}
            </div>

            <div class='col-md-3'>
                {!! Form::label('date_fin', 'Date de fin', ['class' => '']) !!}
                 {!! Form::text('date_fin','', 
                        ['placeholder' => 'Date', 'class' => 'form-control']) !!}
            </div>

            <div class='col-md-2'>
                {!! Form::label('', '&nbsp;', ['class' => '']) !!}
                {!! Form::text('nbjours', '', ['id'=>'nbjours','class' => 'form-control','style'=>'border:0px;font-weight:bold']) !!}
            </div>
        </div>
        <div class="form-group row">
            <div class='col-md-4'>
                {!! Form::label('id_type_stage', 'Type de stage') !!}
                {!! 
                    Form::select(
                        'id_type_stage',
                        array(""=>" ")+$types,
                        $type_defaut,
                        [
                            'class' => 'form-control',
                        ]
                    ) 
                !!} 
            </div>
        </div>

        <div class="form-group row">
            <div class='col-md-4'>
            {!! Form::label('id_classe', 'Classe') !!}
                {!! 
                    Form::select(
                        'id_classe',
                        array(""=>" ")+$classes,
                        '',
                        [
                            'class' => 'form-control',
                        ]
                    ) 
                !!} 
            </div>
        </div>

        <div class='form-group'>
                {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
                <a class="btn btn-warning"  href="{!! url('sessions') !!}">Retour</a>
        </div>

        {!! Form::close() !!}
 
    </div>
 
</div>

@endsection



@section('scripts')
        <script>
            jQuery(document).ready(function() {
                $('#datepicker_date_deb').datepicker({
                    format: "dd/mm/yyyy",language: "fr",autoclose: true
                 });

                $('#datepicker_date_fin').datepicker({
                    format: "dd/mm/yyyy",language: "fr",autoclose: true
                 });

               function formatDateInput(date){
                    //if(date.length<>10) return "";
                    var elem = date.split('/');
                    if (elem[0] === 'undefined') return "";
                    if (elem[1] === 'undefined') return "";
                    if (elem[2] === 'undefined') return "";
                    jour = elem[0];if(jour=="") return "";
                    mois=elem[1];if(mois=="") return "";
                    annee=elem[2];if(annee=="") return "";
                    
                    var date_ok=  annee+"-"+mois+"-"+jour;
                    return new Date(date_ok);
                 
                }

                function calcul_jours() {
                    var date_deb=formatDateInput($('#date_deb').val());
                    if(date_deb=="") return;
                    var date_fin=formatDateInput($('#date_fin').val());
                    if(date_fin=="") return;
                                        
                    var Diff_temps = date_fin.getTime() - date_deb.getTime();
                    var Diff_jours = Diff_temps / (1000 * 3600 * 24); 
                    $('#nbjours').val(Diff_jours+" jours de stage");
                }
                $('#date_deb').change(function () {calcul_jours();});
                $('#date_fin').change(function () {calcul_jours();});

                calcul_jours();
                
            });

            nbjours
        </script>
@endsection
