@extends('layouts.dash_pop')

{!! $with_navbar=false !!}
@section('title')Eleves @stop
@section('title_card',"")

@section('content')
        @if (Session::has('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
            <script>
                parent.location.reload();
                parent.jQuery.fancybox.close();
            </script>
        @else
            <div class="card card-info"> 
                @if ($errors)
                    @foreach ($errors->all() as $error)
                        <div class='bg-danger alert'>{!! $error !!}</div>
                    @endforeach
                @endif
                <div class="card-header">
                    <h3 class="card-title">{!! "Nouvelle session de stage - Classe : ".$classe->nom !!}
                        @if($groupe) {!! "Groupe : ".$groupe !!} @endif
                    </h3>
                </div> 
                <div class="col-lg-max col-lg-offset-1 container-fluid">
                    {{ html()->form('POST', url('/sessions'))->open() }}   
                        <input type="hidden" name="from_pop" value="true"/>
                        <input type="hidden" name="id_classe" value="{{ $classe->id }}"/>
                        <input type="hidden" name="groupe" value="{{ $groupe }}"/>
                        @include('stages.sessions.content_pop')      
                    {{ html()->form()->close() }}
                </div>
            </div>
        @endif
@endsection




