@extends('layouts.dash_pop')

{!! $with_navbar=false !!}
@section('title')Session @stop
@section('title_card',"")

@section('content')
        @if (Session::has('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
            <script>
                parent.location.reload();
                parent.jQuery.fancybox.close();
            </script>
        @else
            @if ($errors)
                @foreach ($errors->all() as $error)
                    <div class='bg-danger alert'>{!! $error !!}</div>
                @endforeach
            @endif
            <div class="card card-info"> 
                <div class="card-header">
                    <h3 class="card-title">{!! "Classe : ".$classe->nom !!}
                        @if($groupe) {!! "Groupe : ".$groupe !!} @endif
                    </h3>
                </div> 
                <div class="col-lg-max col-lg-offset-1 container-fluid">
                    {{ html()->modelForm($sessionstage, 'PUT', url('/sessions/' . $sessionstage->id))->open() }}
                        <input type="hidden" name="from_pop" value="true"/>
                        <input type="hidden" name="id_classe" value="{{ $classe->id }}"/>
                        <input type="hidden" name="groupe" value="{{ $groupe }}"/>
                        @include('stages.sessions.content_pop')
                    {{ html()->closeModelForm() }}
                </div>
            </div>
        @endif
@endsection




