@extends('layouts.dash')

@section('title') Sessions @stop
@section('title_card',"Sessions")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <a href="{!! url('sessions_calendar') !!}" class="btn btn-success btn-sm">
                <i class='fa fa-calendar'></i>&nbsp;&nbsp;Agenda
            </a> 
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label>Classe</label>
                        {!! html()->select('classe')->options($classes)->value($classe?$classe->id:'')
                            ->placeholder('Choisir une catégorie')
                            ->attributes(['id'=>'classes','class' => 'form-control','onchange'=>'select_classe()']) 
                        !!} 
                        <script>
                            $('#classes').selectmenu('refresh');
                            function select_classe() {
                                var select = document.getElementById('classes');
                                var selected = [...select.selectedOptions].map(option => option.value);
                                var url="" ; 
                                if(selected=="") url="{!! url('sessions_list/0') !!}";
                                else url="{!! url('sessions_list/') !!}/"+selected;
                                location.href=url;
                            }
                        </script>
                    </div> 
                </div>
            </div>

            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th width='10%'>Type de stage</th>
                        <th width='1%'>Début</th>
                        <th width='1%'>Fin</th>
                        <th width='1%'>Durée</th>
                        <th>Classe</th>
                        <th width='10%'>NbElèves</th>
                        <th width='10%'>Stages</th>
                        <th width='10%'>Statut</th>
                        <th width='100px'>
                            @if($user->can("ajouter sessions") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('sessions/create') !!}" class="btn btn-success  btn-sm">
                                Ajouter une&nbsp;Session</a>   
                            @endif
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($sessions as $session)
                    <tr class=''>
                        <td>{!! $session->nom !!}</td>
                        <td>{!! $session->NomTypeStage !!}</td>
                        <td >{!! $session->date_deb !!}</td>
                        <td >{!! $session->date_fin !!}</td>
                        <td nowrap>{!! $session->duree." jours" !!}</td>
                        <td nowrap>{!! $session->nom_classe !!}</td>
                        <td nowrap>{!! $session->nb_eleves !!}</td>
                        <td>{!! $session->nb_stages !!}</td>
                        <td>{!! $session->statut !!}</td>
                        <td nowrap>
                            @if(($session->statut!='TER')&&($menu!="sessions terminées"))
                                <a href="{!! url('sessions_generation/'.$session->id) !!}" 
                                    class="btn btn-warning btn-sm" style="margin: 3px;margin-left: 0px;">
                                   Gérer les Stagiaires
                                </a>

                                <a href="{!! url('sessions/'.$session->id.'/edit') !!}" class="btn btn-info btn-sm pull-left" style="margin-right: 3px;">
                                    Modifier la session
                                </a>
                            @endif

                            @if($session->CanDelete)
                                {{ html()->form('DELETE', url('/sessions/'. $session->id))->open() }}   
                                {{ csrf_field() }}
                            @endif
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                            @if($session->CanDelete)
                                {{ html()->form()->close() }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection