<script>

$(document).ready(function() {  
    var calendarEl = document.getElementById('calendar');
    var initialLocaleCode = 'fr';
    var calendar = new FullCalendar.Calendar(calendarEl, {
        //themeSystem: 'bootstrap',
        locale: initialLocaleCode,
        //defaultView: 'agendaWeek',
        themeSystem: 'standard',
        initialDate: '{!! date("Y-m-d") !!}',
        initialView: 'timeGridWeek',
        slotMinTime : '07:00:00',
        slotMaxTime : '21:00:00',
        slotDuration: '00:30:00',
        allDaySlot: false,
        weekNumbers :true,
        expandRows: true,
        eventMinHeight: 1,
        hiddenDays: [ 0],
        nowIndicator: true,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,listWeek', //,timeGridDay
        },
        height: 'auto',
        //footer: false,
        weekends: true,
        slotEventOverlap: false,
        //timezone: 'local',
        navLinks: true, // can click day/week names to navigate views
        //eventTextColor: '',
        loading: function (isLoading) {
                    if (isLoading) {
                        $('#loading').show();
                    }
                    else {                
                        $('#loading').hide();
                    }
                },

        editable: true,
        selectable: true,
        //selectMirror: true,
        dayMaxEvents: true, // allow "more" link when too many events
        //textEscape: true,
        
        eventDidMount: function(info) {
            var element = $(info.el);
            var title = element.find('.fc-event-title');
            title.html(title.text() );
            var title = element.find('.fc-list-event-title');
            title.html(title.text() );
            },

        eventDrop: function (event, dayDelta, minuteDelta) {
            alert('drop');
        },

        eventResize: function (event) {
            alert('resize');
        },

        eventClick: function(info, jsEvent, view) {

        	alert('click1');
        },


 
        dateClick: function (info) {
            alert('click2');
        },


    });

    // *** DATA ****
    calendar.setOption('themeSystem', 'journal');



    calendar.setOption('themeSystem', 'journal');


    calendar.render();


});
</script>

