@extends('layouts.dash_agenda')

@section('title') Sessions @stop
@section('title_card',"Sessions")
@section('subtitle_card',"Liste")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <a href="{!! url('sessions') !!}" class="btn btn-success  btn-sm">
                <i class='fa fa-list'></i>&nbsp;&nbsp;Liste des Sessions</a> 
        </div>
        <div class="card-body">
            <div id='calendar'></div>
        </div>

    </div>
@endsection


@section('scripts')
    @include('stages.sessions.script_calendar')
@endsection

@section('scripts0')

@endsection

