@extends('layouts.dash')

@section('content')
    <!-- Right Panel -->
    <div id="right-panel" class="right-panel">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <h1><i class='fa fa-entreprise'></i> Mise à jour de l'Etablissement</h1>
            {!! Form::model($etablissement, 
                ['class' => 'form-horizontal', 'url' => '/etablissements/' . $etablissement->id, 
                    'method' => 'PUT','files' => true]) !!}
            
            @include("structures.etablissements.content")

            <div class='form-group '>
                {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
                <a class="btn btn-warning"  href="{!! url('etablissements') !!}">Retour</a>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div><!-- /#right-panel -->
@endsection