@extends('layouts.dash_pop')

@section('title') Importation @stop
@section('title_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{!! Session::get('message') !!}</div>
        <script>
            setTimeout(close_form, 3000);
            function close_form() {
                parent.location.reload();
                parent.jQuery.fancybox.close();
            }
        </script>
    @else
        <div class="card">
        	<div class="card-header bg-info">
        		<h5>Importation de données : {{ $table }}</h5>
        	</div>
            <div class="card-body">
                 <form name="form_upload_csv" id="form_upload_csv" 
                    action="{{ url('/importations_pop') }}" method="POST" enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input type="hidden" value="{{ $table }}"  name="table">
                        <div class="form-group row">
                            <div class="col-md-12" id="div_choix">
                                <h5  align="center" style='padding-bottom:5px'><b>Attention !!</b>&nbsp;Le format doit être le suivant : </h5>
                                <div align="center" style='padding:15px' >
                                    <span class="lib_format">
                                        {!! $t_detail['libelle'] !!}
                                    </span>
                                </div>
                        
                                <div style='padding-top:15px' align='center'>
                                    Vous pouvez partir d'un fichier modèle en&nbsp;
                                    <a  target="_blank" href="{!! url('storage/modeles/'.$table.'.csv') !!}">cliquant ici</a>
                                    &nbsp;pour le télécharger
                                </div>
                            </div>

                            <div class="col-md-12" id="div_import">
                                <div class="form-group row">
                                    <div class="col-md-12" align='center' id="">
                                    	<input type="file" id="file_csv" name="file_csv" style="visibility:hidden" class="form-control-file file_csv" accept=".csv" />
                                        <label for="file_csv" title=" Ajouter un document (1,5Mo maxi)" id="file_csv" class="btn btn-success btn-sm" >
                                            <i class="fa fa-upload"></i>&nbsp;&nbsp;Importer la liste des enseignants au format .csv
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div align="center" class="col-md-12" id="div_validation">
                                <a  href="#" class="btn btn-success btn-sm" type="submit" id="btn_validation">
                            		Importer les données du fichier 
                            		<br/>{!! html()->label('&nbsp;', 'nom_file_csv')->attributes(['id'=>'nom_file_csv']) !!}</a>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4"></div>
                            <div class="col-md-8" >
                                <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                    <input name="truncate" id="truncate" type="checkbox" value="1" class="custom-control-input"  >
                                    <label class="custom-control-label" for="truncate">Supprimer les données existantes</label>
                                </div>
                            </div>
                        </div>
                        <input type="submit" value="Upload Image" style="visibility:hidden" id="submit">
                 </form>
            </div>
        </div>



    @endif
@endsection

@section('styles')
    <style>
    	.lib_format{
    		//padding:25px;
    		margin:15px;
    		background-color:#e7e9d1;
    		font-size:1em;
    		font-family:courier;
    		font-weight:bold;
    		color:darkred;
    	}

    </style>
@stop


@section('scripts')
    @if (!Session::has('message'))
        <script>
        	$(function () {
	            $(".file_csv").change(function() {
                    $( "#form_upload_csv" ).submit();
	                id=this.id;
	                var fu1 = document.getElementById(id);
	                var size=document.getElementById(id).files.item(0).size;
	                var name=document.getElementById(id).files.item(0).name;

	                if(size>1572864) { //1 048 576 =1Mo, ici 1,5Mo
	                    alert("Le document ne doit pas dépasser 1,5Mo");
	                    return
	                }
	                $( "#nom_file_csv" ).html(name);
	                $( "#div_import" ).hide();$( "#div_choix" ).hide();
	                $( "#div_validation" ).show();
	                
	                $( "#form_upload_csv" ).submit();
	                return ;
	            });
            });

        	$("#btn_validation").click(function() {
                $("#submit").click();
        	 });

            function importe_document() {
                $("#file_csv").click();
            }

            $("#div_validation" ).hide();
        </script>
    @endif
@endsection


