@extends('layouts.dash_pop')

@section('title') Importation @stop
@section('title_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{!! Session::get('message') !!}</div>
        <script>
            setTimeout(close_form, 3000);
            function close_form() {
                parent.location.reload();
                parent.jQuery.fancybox.close();
            }
        </script>
    @else
        <div class="card">
        	<div class="card-header bg-info">
        		<h5>Importation de données depuis une extracion SIECLE</h5>
        	</div>
            <div class="card-body">
                {{ html()->form('POST', url('importations_siecle_pop'))
                    ->attributes(['id'=>'form_upload_siecle','enctype'=>'multipart/form-data',])->open() }}   
                        {{ csrf_field() }}
                        <div class="form-group row">
                            <div class="col-md-12" id="div_choix">
                                <h5  align="center" style='padding-bottom:5px'><b>Attention !!</b>&nbsp;Le format doit être le suivant : </h5>
                                <div align="center" style='padding:15px' >
                                    <span class="lib_format">
                                        
                                    </span>
                                </div>
                        
                                <div style='padding-top:15px' align='center'>
                                    Pour avoir des informations sur la prodcédure d'extraction SIECLE :
                                    <a  target="_blank" href="{!! url('') !!}">cliquer ici</a>
                                </div>
                            </div>

                            <div class="col-md-12" id="div_import">
                                <div class="form-group row">
                                    <div class="col-md-12" align='center' id="">
                                    	<input type="file" id="file_xml" name="file_xml" style="visibility:hidden" class="form-control-file file_xml" accept=".xml" />
                                        <label for="file_xml" title=" Ajouter un document (5Mo maxi)" id="file_xml" class="btn btn-success btn-sm" >
                                            <i class="fa fa-upload"></i>&nbsp;&nbsp;Importer le fichier .xml
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div align="center" class="col-md-12" id="div_validation">
                                <a  href="#" class="btn btn-success btn-sm" type="submit" id="btn_validation">
                            		Importer les données du fichier 
                            		<br/>
                                    {!! html()->label('&nbsp;', 'nom_file_siecle')->attributes(['id'=>'nom_file_siecle']) !!}
                                </a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4"></div>
                            <div class="col-md-8" >
                                <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                    <input name="truncate" id="truncate" type="checkbox" value="1" class="custom-control-input"  >
                                    <label class="custom-control-label" for="truncate">Supprimer les données existantes</label>
                                </div>
                            </div>
                        </div>
                        <input type="submit" value="Upload Image" id="submit">
                 {{ html()->form()->close() }}
            </div>
        </div>
    @endif
@endsection

@section('styles')
    <style>
    	.lib_format{
    		//padding:25px;
    		margin:15px;
    		background-color:#e7e9d1;
    		font-size:1em;
    		font-family:courier;
    		font-weight:bold;
    		color:darkred;
    	}

    </style>
@stop


@section('scripts')
    @if (!Session::has('message'))
        <script>
        	$(function () {
	            $(".file_xml").change(function() {
                    $( "#form_upload_siecle" ).submit();
	                id=this.id;
	                var fu1 = document.getElementById(id);
	                var size=document.getElementById(id).files.item(0).size;
	                var name=document.getElementById(id).files.item(0).name;

	                if(size>5242880) { //1 048 576 =1Mo, ici 1,5Mo
	                    alert("Le document ne doit pas dépasser 1,5Mo");
	                    return
	                }
	                $( "#nom_file_siecle" ).html(name);
	                $( "#div_import" ).hide();$( "#div_choix" ).hide();
	                $( "#div_validation" ).show();
	               //$( "#submit" ).click();
	                $( "#form_upload_siecle" ).submit();
	                return ;
	            });
            });

        	$("#btn_validation").click(function() {
                $( "#submit" ).click();
                //$( "#form_upload_siecle" ).submit();
                alert('toto');
                return ;
        	 });

            function importe_document() {
                $( "#form_upload_siecle" ).submit();
                return ;

            }

            $("#div_validation" ).hide();
        </script>
    @endif
@endsection


