@extends('layouts.dash_pop')

@section('title') Importation @stop
@section('title_card',"")

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
        <script>
            function close_form() {
                parent.location.reload();
                parent.jQuery.fancybox.close();
            }
        </script>

    @if($import_statut=="PRE")
        {{ html()->form('POST', url('/importXML_valide'))->open() }}   

        {!! html()->text( 'file_name',$file_name) !!}
        {!! html()->hidden( 'id_etablissement',$etablissement->id) !!}

        <h3>Analyse du fichier .xml <small>{!! $file_name !!}</small></h3>

        <div class="alert alert-warning alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-exclamation-triangle"></i> ccAlert!</h5>
            Intégration des données depuis le fichier .xml <b>{!! $file_name !!}</b>
        </div>
        <div class="form-group row">
            <div class="col-md-12">
                {!! html()->label("Etablissement", 'nom_etablissement') !!}
                {!! html()->text('nom_etablissement', $etablissement->nom)->attributes(['readonly', 'class' => 'form-control']) !!}
            </div>
        </div>
        <div class="form-group row">
            <div class="col-md-4">
                {!! html()->label("Nombre d'élèves du fichier .xml", 'nb_eleves_xml') !!}
                {!! html()->text('nb_eleves_xml', $nb_eleves_xml)->attributes(['readonly', 'class' => 'form-control']) !!}
            </div>
        </div>

        <div class="form-group">
            <div class="custom-control custom-checkbox">
              <input class="custom-control-input custom-control-input-danger" type="checkbox" name="init_base" id="init_base" checked="" value="1">
              <label for="init_base" class="custom-control-label">Initialiser la base élèves et classes (actuellement {!! $nb_eleves !!} élèves)</label>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4" style="margin-top:30px">
                    <button type="submit" class="btn btn-success btn-sm">
                    <i class="fa fa-upload"></i> Lancer l'importation</button>
            </div>
        </div>
        {{ html()->form()->close() }}
    @endif


    @if($import_statut=="VAL")
        <h3>Importations terminée</h3>

        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-chack"></i> Importation terminée</h5>
            {!! $nb_eleves !!} élèves ont été importés avec {!! $nb_classes !!} classes <b></b>
        </div>
    @endif


@endsection


@section('scripts')



@endsection
