 <div class="form-group row">
    <div class="col-md-6">
        <?php echo html()->label('Nom','nom'); ?>

        <?php echo html()->text('nom', null)->attributes([($mode=="show"?'disabled':''),'placeholder' => 'Déniomnation de la session', 'class' => 'form-control']); ?>

     </div>
    <div class="col-md-4" id="div_color">
      <label>Couleur:</label>
      <div class="input-group ">
        <?php echo e(html()->text('color')
            ->value(($mode!="create")?(isset($sessionstage)?$sessionstage->color:'#F90606'):'#F90606')
            ->attributes([($mode=="show"?'disabled':''), 'type' => 'color'])); ?>

      </div>
    </div>
</div>
<div class="form-group row">
    <div class='col-md-3'>
        <?php echo html()->label('Date de debut','date_deb'); ?>

        <?php echo html()->text('date_deb', isset($date_debut)?$date_debut:null)->attributes([($mode=="show"?'disabled':''),'id'=>'date_deb','placeholder' => 'Date', 'class' => 'form-control']); ?>

    </div>

    <div class='col-md-3'>
        <?php echo html()->label('Date de fin','date_fin'); ?>

        <?php echo html()->text('date_fin', isset($date_fin)?$date_fin:null)->attributes([($mode=="show"?'disabled':''),'id'=>'date_fin','placeholder' => 'Date', 'class' => 'form-control']); ?>

    </div>

    <div class='col-md-6'>
        <?php echo html()->label('&nbsp;','nbjours'); ?>

        <?php echo html()->text('nbjours', '')->attributes([($mode=="show"?'disabled':''),'id'=>'nbjours','class' => 'form-control','style'=>'background-color:#FFF;border:0px;font-weight:bold']); ?>

    </div>
</div>

<div class="form-group row">
    <div class='col-md-6'>
        <?php echo html()->label('Professeur référent','id_prof'); ?>

        <?php echo html()->select('id_prof')->options($enseignants)->value(isset($sessionstage)?$sessionstage->id_prof:'')
            ->placeholder('A définir')
            ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

    </div>
</div>


<div class="form-group row">
    <div class='col-md-6'>
        <?php echo html()->label('Type de stage','id_type_stage'); ?>

        <?php echo html()->select('id_type_stage')->options($types)->value(isset($sessionstage)?$sessionstage->id_type_stage:'')
            ->placeholder('A définir')
            ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

    </div>
</div>

<div class='form-group '>
    <?php if($mode!='show'): ?>
        <?php echo html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']); ?>

    <?php else: ?>
        <?php if($sessionstage->CanDelete): ?>
            <?php echo e(html()->closeModelForm()); ?>

            <?php echo e(html()->form('DELETE', url('/sessions/'. $sessionstage->id))->attributes(['style'=>'display:inline'])->open()); ?>   
            <?php echo e(csrf_field()); ?>

                <button onclick="if(!confirm('Voulez-vous vraiement ssupprimer cette session ?')) return false" class="btn btn-danger">Supprimer</button>
            <?php echo e(html()->form()->close()); ?>

        <?php endif; ?>

        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("modifier sessions")): ?>
            <a class="btn btn-primary"  href="<?php echo url('sessions_edit/'.$sessionstage->id); ?>">Modifier</a>
        <?php endif; ?>
    <?php endif; ?>
</div>



<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $('.select2').select2();
            //color picker with addon
            //$('.my-colorpicker2').colorpicker({format: 'hex', });

            $('#date_deb').datepicker({
                format: "dd/mm/yyyy",language: "fr",autoclose: true
             });

            $('#date_fin').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true,
                <?php if(isset($date_debutUS)): ?> startDate: "<?php echo $date_debutUS; ?>", <?php endif; ?>
                

               
             });

           function formatDateInput(date){
                //if(date.length<>10) return "";
                var elem = date.split('/');
                if (elem[0] === 'undefined') return "";
                if (elem[1] === 'undefined') return "";
                if (elem[2] === 'undefined') return "";
                jour = elem[0];if(jour=="") return "";
                mois=elem[1];if(mois=="") return "";
                annee=elem[2];if(annee=="") return "";
                
                var date_ok=  annee+"-"+mois+"-"+jour;
                return new Date(date_ok);
             
            }

            function calcul_jours() {
                var date_deb=formatDateInput($('#date_deb').val());
                if(date_deb=="") return;
                var date_fin=formatDateInput($('#date_fin').val());
                if(date_fin=="") return;
                                    
                var Diff_temps = date_fin.getTime() - date_deb.getTime();
                var Diff_jours = Diff_temps / (1000 * 3600 * 24); 
                $('#nbjours').val(Diff_jours+" jours de stage");
            }
            $('#date_deb').change(function () {calcul_jours();});
            $('#date_fin').change(function () {calcul_jours();});
            calcul_jours();
            
        });
    </script>
<?php $__env->stopSection(); ?><?php /**PATH /var/www/html/lycee.gpfmp.fr/resources/views/stages/sessions/content_pop.blade.php ENDPATH**/ ?>