

<?php $__env->startSection('title'); ?> Cat.Filières <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Catégories de Filières"); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>


<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
           <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th width='30%'>Nom</th>
                        <th>Nom court</th>
                        <th>Filières</th>
                        <th width='1px'>Nombre de&nbsp;classes</th>
                        <th width='1px'>Nombre d'élèves</th>
                        <th width='1px'>Nombre de&nbsp;stagiaires</th>
                        <th width='1px'>
                            <?php if($user->can("ajouter filieres categories") || $user->hasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('filieres_categories/create'); ?>" 
                                class="btn btn-success btn-sm">
                                <span class='fa fa-plus'></span> Ajouter une catégorie
                            </a>
                            <?php endif; ?>  
                        </th>
                    </tr>
                </thead>
     
                <tbody>
                    <?php $__currentLoopData = $filieres_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class=''>
                        <td>
                            <a href="<?php echo url('/filieres_categories/'.$categorie->id); ?>"><?php echo $categorie->nom; ?></a>
                        </td>
                        <td nowrap><?php echo $categorie->nom_court; ?></td>
                        <td><?php echo $categorie->FilieresHTML; ?></td>
                        <td align="center"><?php echo $categorie->nb_classes; ?></td>
                        <td align="center"><?php echo $categorie->NbEleves; ?></td>
                        <td align="center"><?php echo $categorie->nb_stagiaires; ?></td>
                        <td align="left">
                            <?php if($categorie->CanDelete): ?>
                                <?php echo e(html()->form('DELETE', url('/filieres_categories/'. $categorie->id))->open()); ?> 
                                <?php echo e(csrf_field()); ?>

                            <?php endif; ?>
                            <a title="Consulter" href="<?php echo url('/filieres_categories/'.$categorie->id); ?>" class="btn btn-info btn-sm">
                                <span class='fa fa-eye'></span>
                            </a> 
                            <?php if($categorie->CanDelete): ?>
                                <button class="btn btn-danger btn-sm"><span class='fa fa-trash'></span></button>
                                <?php echo e(html()->form()->close()); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
     
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/lycee.gpfmp.fr/resources/views/structures/filieres_categories/index.blade.php ENDPATH**/ ?>